<?php
/**
 * Define path for required files for Custom Control
 * 
 * @package Shopay
*/

if ( ! function_exists( 'shopay_register_custom_controls' ) ) :
    
    /**
     * Register Custom Controls
     * 
     * @since 1.0.0
    */
    function shopay_register_custom_controls( $wp_customize ) {
        
        // Load our custom control.
        require_once get_template_directory() . '/inc/customizer/custom-controls/toggle/class-toggle-control.php';
        require_once get_template_directory() . '/inc/customizer/custom-controls/repeater/class-repeater-control.php';
        require_once get_template_directory() . '/inc/customizer/custom-controls/radio-image/class-radio-image-control.php';
        require_once get_template_directory() . '/inc/customizer/custom-controls/divider/class-divider-control.php';
        
        // Register the control type.
        $wp_customize->register_control_type( 'Shopay_Control_Toggle' );
        $wp_customize->register_control_type( 'Shopay_Control_Radio_Image' );
        $wp_customize->register_control_type( 'Shopay_Control_Divider' );
    }

endif;

add_action( 'customize_register', 'shopay_register_custom_controls' );